/*** CONFIDENTIAL ***/
/* Copyright (C) 2011 2012 2013, Panasonic Corporation */
#ifndef _ev_id_h_
#define _ev_id_h_

typedef UINT32 EV_ID;

#define EV_ID_BIT       0x80000000UL
#define EV_FLAG64_BIT   0x40000000UL
#define EV_FLAG_BIT     0x20000000UL
#define EV_QUEUE_BIT    0x10000000UL
#define EV_AUTO_ID_BIT  0x08000000UL
#define EV_RESERVED_BIT 0xff000000UL
#define EV_INVALID_ID   EV_ID_BIT
#define EV_NO_ID        EV_INVALID_ID

#define EV_ID_IS_FLAG(queueID) \
  (((queueID) & (EV_ID_BIT|EV_FLAG_BIT)) == (EV_ID_BIT|EV_FLAG_BIT))
#define EV_ID_IS_FLAG64(queueID) \
  (((queueID) & (EV_ID_BIT|EV_FLAG64_BIT)) == (EV_ID_BIT|EV_FLAG64_BIT))
#define EV_ID_IS_QUEUE(queueID) \
  (((queueID) & (EV_ID_BIT|EV_QUEUE_BIT)) == (EV_ID_BIT|EV_QUEUE_BIT))
#define EV_ID_IS_AUTO_ID(queueID) \
  (((queueID) & (EV_ID_BIT|EV_AUTO_ID_BIT)) == (EV_ID_BIT|EV_AUTO_ID_BIT))
#define EV_ID_IS_VALID(queueID) \
  (EV_ID_IS_FLAG(queueID) || EV_ID_IS_FLAG64(queueID) || EV_ID_IS_QUEUE(queueID))

#define EV_Flag_ID_Base(mod) (EV_ID_BIT|EV_FLAG_BIT|((mod)<<8))

#define EV_Flag64_ID_Base(mod) (EV_ID_BIT|EV_FLAG64_BIT|((mod)<<8))

#define EV_Queue_ID_Base(mod) (EV_ID_BIT|EV_QUEUE_BIT|((mod)<<8))

#endif
